<?php

namespace Mtc\Filter\Contracts;

use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Resources\Json\JsonResource;

interface FilterObject
{
    public function createQuery(): Builder;

    public function getResults(Builder $query): LengthAwarePaginator;

    public function format(LengthAwarePaginator $results): JsonResource;

    public function applyFilter(Builder $query): void;
}