<?php

namespace Mtc\Filter;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Mtc\Filter\Contracts\FilterInstance;
use Mtc\Filter\Contracts\FilterSeoContract;
use Mtc\Filter\Contracts\SeoMatchingMechanism;

class FilterSeo implements FilterSeoContract
{
    /**
     * Local variable that identifies whether match has been found
     *
     * @var bool
     */
    protected bool $matched = false;

    /**
     * Get Seo Data from Filter
     *
     * @param FilterInstance $filter
     * @return array
     */
    public function handle(FilterInstance $filter): array
    {
        return $this->findSeoMatch($filter)->getData($filter);
    }

    /**
     * Find the mechanism that should be used for getting SEO data
     *
     * @param FilterInstance $filter
     * @return SeoMatchingMechanism
     */
    protected function findSeoMatch(FilterInstance $filter): SeoMatchingMechanism
    {
        return collect(Config::get('filter.seo_data_matching', []))
            ->map(fn($matching_mechanism) => App::make($matching_mechanism))
            ->filter(function (SeoMatchingMechanism $mechanism) use ($filter) {
                return !$this->matched && ($this->matched = $mechanism->matchesRequest($filter));
            })
            ->first();
    }
}