<?php

namespace Mtc\Filter\Filters;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Mtc\Filter\Contracts\IsFilter;
use Mtc\Shop\Brand;
use Mtc\Shop\Item;

class BrandFilter extends IsFilter
{

    public function applyFilter($query, array $selection = [])
    {
        $query->whereHas('brands', function (Builder $brand_query) use ($selection) {
            $brand_query->whereIn('brands.id', $selection)
                ->active();
        });
    }

    public function getResults(\Closure $product_filtering, int $limit, array $selections = []): Collection
    {
        return Brand::query()
            ->active()
            ->whereHas('items', function ($item_query) use ($product_filtering) {
                return $product_filtering($item_query);
            })
            ->addSelect([
                'result_count' => Item::query()
                    ->selectRaw('count(*)')
                    ->join('items_brands', 'item_id', '=', 'items.id')
                    // TODO Active brand check
                    ->where(function ($item_query) use ($product_filtering) {
                        $product_filtering($item_query);
                    })
                    ->whereRaw(DB::raw('brands.id = `brand_id`')),

            ])
            ->orderByDesc('result_count')
            ->when($limit > 0, function ($query) use ($limit) {
                $query->limit($limit);
            })
            ->get();
    }

    public function getModel(): string
    {
        return Brand::class;
    }

    public function title(): string
    {
        return 'Brand';
    }

    public function modelSlug(Model $model): string
    {
        return $model->name;
    }
}