<?php

namespace Mtc\Filter\Filters;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Mtc\Filter\Contracts\CustomPatternFilter;
use Mtc\Filter\Contracts\IsFilter;
use Mtc\Shop\Item;

class PriceFilter extends IsFilter implements CustomPatternFilter
{
    public function title(): string
    {
        return 'Price';
    }

    public function getNameAttribute(): string
    {
        return 'name';
    }

    public function uiComponentType(): string
    {
        return 'range-slider-filter';
    }

    public function applyFilter($query, array $selection = [])
    {
        $query->where('sort_price', '>=', $selection[0]['min'] ?? 0)
            ->where('sort_price', '<=', $selection[0]['max'] ?? PHP_INT_MAX);
    }

    public function getResults(\Closure $product_filtering, int $limit, array $selections = []): Collection
    {
        return collect([
            'min' => floor(Item::query()->where($product_filtering)->min('sort_price')),
            'max' => ceil(Item::query()->where($product_filtering)->max('sort_price')),
        ]);
    }

    public function format(Collection $collection): array
    {
        return [
            'title' => $this->title(),
            'ui_component' => $this->uiComponentType(),
            'has_load_more' => $this->hasLoadMore($collection),
            'results' => $collection,
        ];
    }

    public function getModel(): string
    {
        return Item::class;
    }

    public function modelSlug(Model $model): string
    {
        return '';
    }

    public function patternMatched(string $selection): bool
    {
        return preg_match('/price-from-[0-9]+-to-[0-9]+/', $selection);
    }

    public function matchSelections(string $selection)
    {
        preg_match('/price-from-([0-9]+)-to-([0-9]+)/', $selection, $matches);
        return [
            'min' => $matches[1],
            'max' => $matches[2],
        ];
    }

    public function createSlug($selection): string
    {
        return 'price-from-' . $selection['min'] . '-to-' . $selection['max'];
    }
}