<?php

namespace Mtc\Filter\Filters;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Mtc\Filter\Contracts\IsFilter;
use Mtc\Shop\Item\Size;

class SizeFilter extends IsFilter
{

    public function applyFilter($query, array $selection = [])
    {
        $query->whereHas('sizes', function (Builder $brand_query) use ($selection) {
            $brand_query->whereIn('size', $selection);
        });
    }

    public function getResults(\Closure $product_filtering, int $limit, array $selections = []): Collection
    {
        return Size::query()
            ->active()
            ->selectRaw(DB::raw('DISTINCT(size)'))
            ->whereHas('item', $product_filtering)
            ->addSelect([
                'result_count' => Size::query()
                    ->active()
                    ->from('items_sizes', 'items_sizes2')
                    ->selectRaw('count(*)')
                    ->whereHas('item', function ($item_query) use ($product_filtering) {
                        $this->adjustRelationshipName($item_query, 'items_sizes2.item_id');
                        $product_filtering($item_query);
                    })
                    ->whereRaw(DB::raw('items_sizes.size = items_sizes2.size')),
            ])
            ->orderByDesc('result_count')
            ->when($limit > 0, function ($query) use ($limit) {
                $query->limit($limit);
            })
            ->get();
    }

    public function getModel(): string
    {
        return Size::class;
    }

    public function getNameAttribute(): string
    {
        return 'size';
    }

    public function getIdAttribute(): string
    {
        return 'size';
    }

    public function title(): string
    {
        return 'Size';
    }

    public function modelSlug(Model $model): string
    {
        return $model->size;
    }
}