<?php

namespace Mtc\Filter\Http\Controllers;

use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Filter\Contracts\FilterInstance;
use Mtc\Filter\Facades\Filter;
use Mtc\Filter\FilterSeo;
use Mtc\Shop\Item;

class FilterController extends Controller
{
    /**
     * Render browse page
     *
     * @param Request $request
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View|array
     */
    public function index(Request $request, FilterInstance $filter)
    {
        $data = $filter->parseRequest();
        if ($request->has('inaccessible_item')) {
            $data['inaccessible_item'] = Item::query()
                ->select(['name', 'deleted'])
                ->find($request->has('inaccessible_item'));
        }
        return template('filter/index.twig', $data);

    }

    /**
     * Handle Filter ajax call
     *
     */
    public function show(FilterInstance $filter)
    {
        return $filter->handle();
    }
}
