<?php

namespace Mtc\Filter\Providers;

use Mtc\Filter\Console\Commands\MakeFilter;
use Mtc\Filter\Console\Commands\MakeFilterSort;
use Mtc\Filter\Console\Commands\RefreshFilterIndex;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Route;
use Mtc\Core\Providers\RouteServiceProvider;
use Mtc\Filter\Contracts\FilterInstance;
use Mtc\Filter\Contracts\FilterObject;
use Mtc\Filter\Contracts\FilterSeoContract;

class FilterProvider extends RouteServiceProvider
{
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/filter.php', 'filter');
        $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');

        parent::register();
    }

    public function boot()
    {
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'filter');
        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');

        parent::boot();

        $this->app->bind(FilterSeoContract::class, Config::get('filter.seo_handler'));
        $this->app->bind(FilterObject::class, Config::get('filter.filter_object'));
        $this->app->bind(FilterInstance::class, Config::get('filter.filter_instance'));
        $this->app->bind('product-filter', Config::get('filter.filter_instance'));

        $this->commands([
            RefreshFilterIndex::class,
            MakeFilterSort::class,
            MakeFilter::class,
        ]);
    }

    public function map()
    {
        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
    }
}