<?php

namespace Mtc\Filter\Seo;

use Mtc\Core\Seo\Heading;
use Mtc\Core\Seo\Page;
use Mtc\Filter\Contracts\FilterInstance;
use Mtc\Filter\Contracts\SeoMatchingMechanism;

class MatchExactUrl implements SeoMatchingMechanism
{
    /**
     * Perform a check if this mechanism should be used for setting up SEO
     * data for the page
     *
     * @param FilterInstance $filter
     * @return bool
     */
    public function matchesRequest(FilterInstance $filter): bool
    {
        return Page::query()
            ->where('path', $filter->getPageUrl(false))
            ->exists();
    }

    /**
     * Obtain SEO data for given filter object/page
     *
     * @param FilterInstance $filter
     * @return array
     */
    public function getData(FilterInstance $filter): array
    {
        $page = Page::query()
            ->where('path', $filter->getPageUrl(false))
            ->first();

        $heading = Heading::query()
            ->where('path', $filter->getPageUrl(false))
            ->first();

        return [
            'title' => $page->title ?? '',
            'description' => $page->description ?? '',
            'heading' => $heading->text ?? '',
        ];
    }
}