<?php

namespace Mtc\Filter\Contracts;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;

interface FilterInstance
{
    /**
     * Parse Request to selections and filter data
     *
     * @return array
     */
    public function parseRequest(): array;

    /**
     * Handle Ajax request, perform filtering
     *
     * @return array
     */
    public function handle(): array;

    /**
     * Get enabled filters
     *
     * @return Collection
     */
    public function getFilters(): Collection;

    /**
     * Get current selections
     *
     * @param string|null $type
     * @return array
     */
    public function getSelections(string $type = null): array;

    /**
     * Build the URL of the page that has been viewed
     *
     * @param bool $absolute
     * @return string
     */
    public function getPageUrl(bool $absolute = true): string;

    /**
     * Get the current pagination page of the filter
     *
     * @return int
     */
    public function getCurrentPage(): int;

    /**
     * Build URL for array of selections
     *
     * @param array $selections
     * @return string
     */
    public function urlForSelections(array $selections): string;

    /**
     * Create an instance of Filter for type
     *
     * @param string $type
     * @return IsFilter
     */
    public function instantiateFilter(string $type): IsFilter;

    /**
     * Find a list of filter types for indexing
     *
     * @param Model $model
     * @return Collection
     */
    public function findIndexTypesForModel(Model $model): Collection;
}
