<?php

namespace Mtc\Filter\Seeds;

use Illuminate\Database\Seeder;

class FilterAdminMenuSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $shop_menu = \Mtc\Core\Admin\Menu::query()
            ->firstOrCreate([
                'title' => 'Shop'
            ], [
                'icon' => 'fas fa-shopping-cart'
            ]);

        if ($shop_menu->id) {
            $shop_sub_menu = $this->getShopSubMenu();
            foreach ($shop_sub_menu as $sub_menu) {
                $roles = $sub_menu['roles'] ?? [];
                unset($sub_menu['roles']);
                $child = $shop_menu->children()->create($sub_menu);
                \Mtc\Core\Admin\Menu::grantMenuPermissionToRole($child, $roles);
            }
        }
    }

    /**
     * Get admin menu (shop submenu) data
     *
     * @return array
     */
    protected function getShopSubMenu(): array
    {
        return [
            [
                'title' => 'Product Filter',
                'path' => '/admin/filter',
                'activePath' => '/admin/filter',
                'constant' => '',
                'order' => 10,
                'roles' => [
                    'Administrator'
                ],
            ],
        ];
    }
}
