<?php

namespace Mtc\Filter\Console\Commands;

use Exception;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\App;
use Mtc\Filter\Contracts\CustomPatternFilter;
use Mtc\Filter\Contracts\FilterInstance;
use Mtc\Filter\Contracts\IsFilter;
use Mtc\Filter\FilterIndex;

class RefreshFilterIndex extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'filter:refresh-index';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Make sure filter index table is up to date with records';

    /**
     * @var FilterInstance
     */
    protected FilterInstance $filter;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(FilterInstance $filter)
    {
        $this->filter = $filter;
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     * @throws Exception
     */
    public function handle(): int
    {
        $this->filter->getFilters()
            ->reject(fn($filter) => $filter instanceof CustomPatternFilter)
            ->each(function (IsFilter $filter, $type) {
                $this->info("Processing $type");
                $progress_bar = $this->output->createProgressBar(App::make($filter->getModel())->newQuery()->count());
                App::make($filter->getModel())->newQuery()
                    ->chunk(250, function ($chunk) use ($type, $filter, $progress_bar) {
                        $chunk->each(function ($model) use ($type, $filter) {
                            FilterIndex::index($type, $model, $filter);
                        });
                        $progress_bar->advance(250);
                    });
            });

        return 0;
    }
}
