<?php

namespace Mtc\Filter\Http\Controllers;

use Illuminate\Http\Request;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Filter\Contracts\FilterIndexContract;
use Mtc\Filter\Contracts\FilterInstance;

class FilterAdminController extends Controller
{
    /**
     * Render browse page
     *
     * @param Request $request
     * @return string
     */
    public function index(FilterIndexContract $index, FilterInstance $filter): string
    {
        $filters = $filter->getFilters();
        $keys = $filters->keys();
        $this->page_meta['title'] = __('filter::filter.admin.manage_filter_index');
        return template('filter/admin.twig', [
            'page_meta' => $this->page_meta,
            'filters' => $filters,
            'index_groups' => $index->newQuery()
                ->get()
                ->groupBy('filter_type')
                ->sortBy(fn($group, $type) => $keys->search($type) !== false ? $keys->search($type) : PHP_INT_MAX),
        ]);
    }

    /**
     * Update the slug of an index element
     *
     * @param Request $request
     * @param FilterIndexContract $index
     * @return \Illuminate\Database\Eloquent\Builder[]|\Illuminate\Database\Eloquent\Collection
     * @throws \Illuminate\Validation\ValidationException
     */
    public function update(Request $request, FilterIndexContract $index)
    {
        $this->validate($request, [
            'slug' => [
                'required',
                'alpha_dash',
                'unique:filter_index,slug,' . $index->id
            ],
        ]);

        $index->slug = strtolower($request->input('slug'));
        $index->save();
        return $index->newQuery()->where('filter_type', $index->filter_type)->get();
    }

    /**
     * Change order of index elements
     *
     * @param Request $request
     * @param FilterIndexContract $index
     */
    public function reorder(Request $request, FilterIndexContract $index)
    {
        collect($request->input('entries'))
            ->each(fn($entry, $order) => $index->newQuery()
                ->where('id', $entry['id'])
                ->update([
                    'order' => $order
                ]));

        return response('success');
    }
}
