<?php

namespace Mtc\Filter\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Mtc\Filter\Facades\Filter;

use function redirect;

class ProductFilterSearch
{
    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if ($request->has('search-filter') === false) {
            return $next($request);
        }

        $chars_to_replace = [
            '-',
            '/'
        ];
        $search_terms = trim(str_replace($chars_to_replace, ' ', $request->input('search-filter')));

        return !empty($search_terms)
            ? redirect()->to(Filter::urlForSelections(['search' => $search_terms]))
            : $next($request);
    }
}
