<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Filter Instance
    |--------------------------------------------------------------------------
    |
    | This class will be used to perform filtering in system. It has been
    | so it can be changed, but necessity for it should be small
    | as all aspects like filters, object being filtered, sorting and other
    | elements can be managed through other config options
    |
    */
    'filter_instance' => \Mtc\Filter\Filter::class,

    /*
    |--------------------------------------------------------------------------
    | Filters
    |--------------------------------------------------------------------------
    |
    | These are the filters that will be passed down to site. Each filter
    | carries out actions for applying selections, fetching filter choices
    | and other aspects to ensure easy integration in the system. Filter
    | needs to be an instance/extension of IsFilter class.
    | When generating URL filters will be sorted in order listed how they are
    | ordered here (e.g. category/brand/size or /category/category/size)
    |
    */
    'filters' => [
        'category' => \Mtc\Filter\Filters\CategoryFilter::class,
        'brand' => \Mtc\Filter\Filters\BrandFilter::class,
        'size' => \Mtc\Filter\Filters\SizeFilter::class,
        'colour' => \Mtc\Filter\Filters\ColourFilter::class,
        'price' => \Mtc\Filter\Filters\PriceFilter::class,
        'search' => \Mtc\Filter\Filters\SearchTermFilter::class,
    ],

    /*
    |--------------------------------------------------------------------------
    | Filter Index
    |--------------------------------------------------------------------------
    |
    | Filter uses an index model to store and ensure unique url slugs
    | for filters. This config value allows extending/overwriting its model.
    |
    */
    'filter_index_model' => \Mtc\Filter\FilterIndex::class,


    /*
    |--------------------------------------------------------------------------
    | Result Sorting
    |--------------------------------------------------------------------------
    |
    | Sort options available on site. Each class specifies how to order
    | results for the constructed query.
    |
    */
    'default_sort_choice' => 'latest',

    'sort_options' => [
        'latest' => \Mtc\Filter\Sorting\NewArrivals::class,
        'price-desc' => \Mtc\Filter\Sorting\PriceDescending::class,
        'price-asc' => \Mtc\Filter\Sorting\PriceAscending::class,
        'a-to-z' =>\Mtc\Filter\Sorting\Alphabetical::class
    ],

    /*
    |--------------------------------------------------------------------------
    | Filtered Object Class
    |--------------------------------------------------------------------------
    |
    | This is the class that specifies how the filtered object (Product)
    | should be filtered and how to format its results.
    |
    */
    'filter_object' => \Mtc\Filter\ProductFilter::class,

    /*
    |--------------------------------------------------------------------------
    | Limits
    |--------------------------------------------------------------------------
    |
    | result_page_limit = default pagination size for filtered object (product)
    |
    | filter_limit = how many top results to show of each filter (e.g. 5 categories).
    |   Showing only top choices will add "view all" more options that can be fetched
    |   individually. This allows improving performance by loading fewer results and
    |   building fewer urls for filter choices
    |   Setting it to 0 will load all results.
    |
    */
    'result_page_limit' => 15,
    'filter_limit' => 5,
    'get_filter_result_count' => false,

    /*
    |--------------------------------------------------------------------------
    | Entrypoint to page
    |--------------------------------------------------------------------------
    |
    | Starting url slug for the page.
    |    e.g shop for pages like  /shop/jeans
    |
    */
    'url_entrypoint' => 'filter',

    /*
    |--------------------------------------------------------------------------
    | SEO settings
    |--------------------------------------------------------------------------
    |
    | Mechanisms (in priority order) that defined SEO data of the page
    | like page title, description, content etc.
    |
    */

    'seo_handler' => \Mtc\Filter\FilterSeo::class,

    'seo_data_matching' => [
        'exact' => \Mtc\Filter\Seo\MatchExactUrl::class,
        'approximate' => \Mtc\Filter\Seo\MatchApproximateUrl::class,
        'brand' => \Mtc\Filter\Seo\MatchSelectedBrand::class,
        'category' => \Mtc\Filter\Seo\MatchSelectedCategory::class,
        'defaults' => \Mtc\Filter\Seo\MatchSeoDefaults::class,
    ]
];