<?php

namespace Mtc\Filter\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider;
use Mtc\Filter\Console\Commands\MakeFilter;
use Mtc\Filter\Console\Commands\MakeFilterSort;
use Mtc\Filter\Console\Commands\RefreshFilterIndex;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Route;
use Mtc\Filter\Contracts\FilterIndexContract;
use Mtc\Filter\Contracts\FilterInstance;
use Mtc\Filter\Contracts\FilterObject;
use Mtc\Filter\Contracts\FilterSeoContract;

class FilterProvider extends RouteServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/filter.php', 'filter');
        $this->loadMigrationsFrom(dirname(__DIR__, 2) . '/database/migrations');

        parent::register();
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'filter');
        if ($this->app->runningUnitTests() === false) {
            app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
        }

        parent::boot();

        $this->app->bind(FilterSeoContract::class, Config::get('filter.seo_handler'));
        $this->app->bind(FilterObject::class, Config::get('filter.filter_object'));
        $this->app->bind(FilterInstance::class, Config::get('filter.filter_instance'));
        $this->app->bind('product-filter', Config::get('filter.filter_instance'));
        $this->app->bind(FilterIndexContract::class, Config::get('filter.filter_index_model'));


        if ($this->app->runningInConsole()) {
            $this->publishes([
                \dirname(__DIR__, 2) . '/config/filter.php' => config_path('filter.php'),
            ], 'config');

//            $this->publishes([
//                \dirname(__DIR__, 2) . '/resources/css' => public_path('css'),
//            ], 'assets');

            // Publishing assets.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
            ], 'assets');

            $this->publishes([
                dirname(__DIR__, 2) . '/resources/lang' => resource_path('lang/vendor/filter'),
            ], 'lang');

            $this->commands([
                RefreshFilterIndex::class,
                MakeFilterSort::class,
                MakeFilter::class,
            ]);
        }
    }

    /**
     * Define the routes for the application.
     *
     * @return void
     */
    public function map()
    {
        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
    }
}
