<?php

namespace Mtc\Filter\Http\Resources;

use Illuminate\Http\Resources\Json\ResourceCollection;
use Mtc\Shop\Item;

class FilterResultCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'current_page' => $this->currentPage(),
            'data' => $this->mapItems(),
            'first_page_url' => $this->url(1),
            'from' => $this->firstItem(),
            'last_page' => $this->lastPage(),
            'last_page_url' => $this->url($this->lastPage()),
            'next_page_url' => $this->nextPageUrl(),
            'path' => $this->path(),
            'per_page' => $this->perPage(),
            'prev_page_url' => $this->previousPageUrl(),
            'to' => $this->lastItem(),
            'total' => $this->total(),
        ];
    }

    private function mapItems()
    {
        return $this->collection
            ->map(fn($item) => $this->map($item));
    }

    public function map(Item $item)
    {
        return [
            'id' => $item->id,
            'name' => $item->name,
            'url' => $item->getUrl(),
            'is_new' => $item->is_new,
            'price' => $item->getPrice()->toArray(),
            'original_price' => $item->getOriginalPrice()->toArray(),
            'stealth_sale' => $item->stealth_sale,
            'percentage_off' => $item->getPercentageDiscountAttribute(),
            'default_image' => $item->getDefaultImageUrlAttribute('thumbs'),
            'hover_image' => $item->getHoverImageUrlAttribute('thumbs'),
            'sizes' => $item->sizes->pluck('size'),
            'colours' => $item->sizes->pluck('colour'),
            'has_sizes' => $item->sizes->count() > 1,
            'item_message' => [
                'type' => $item->item_message_type,
                'value' => $item->item_message,
            ],
        ];
    }
}
