<?php

namespace Mtc\Filter\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class MakeFilterSort extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:filter-sort {name}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a filter sort option ';

    /**
     * Path where the newly created file be stored
     *
     * @var string
     */
    protected string $destination_directory = 'app/Filter/Sorting/';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle(): int
    {
        $class_name = Str::studly($this->argument('name'));
        $content = File::get(__DIR__ . '/stubs/sort.php.stub');
        $content = str_replace('{{ClassName}}', $class_name, $content);

        File::ensureDirectoryExists(base_path($this->destination_directory));
        File::put(base_path($this->destination_directory . $class_name . '.php'), $content);

        $this->info('Sort option generated. Please add it to your filter config'
            . ' (config/filter.php => sort_options section).');
        return 0;
    }
}
