<?php

namespace Mtc\Filter\Seo;

use Mtc\Filter\Contracts\FilterInstance;
use Mtc\Filter\Contracts\SeoMatchingMechanism;
use Mtc\Shop\Brand;

class MatchSelectedBrand implements SeoMatchingMechanism
{
    /**
     * Perform a check if this mechanism should be used for setting up SEO
     * data for the page
     *
     * @param FilterInstance $filter
     * @return bool
     */
    public function matchesRequest(FilterInstance $filter): bool
    {
        if (count($filter->getSelections('brands')) !== 1) {
            return false;
        }

        return Brand::query()
            ->where('id', $filter->getSelections('brands')[0])
            ->where(function ($query) {
                return $query->where('seo_title', '!=', '')
                    ->orWhere('seo_description', '!=', '');
            })
            ->select([
                'seo_title as title',
                'seo_description as description'
            ])
            ->exists();
    }

    /**
     * Obtain SEO data for given filter object/page
     *
     * @param FilterInstance $filter
     * @return array
     */
    public function getData(FilterInstance $filter): array
    {
        $brand = Brand::query()
            ->where('id', $filter->getSelections('brands')[0])
            ->where(function ($query) {
                return $query->where('seo_title', '!=', '')
                    ->orWhere('seo_description', '!=', '');
            })
            ->select([
                'seo_title as title',
                'seo_description as description'
            ])
            ->first();

        return $brand ? $brand->only(['title', 'description']) : [];
    }
}
