<?php

namespace Mtc\Filter\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Config;
use Mtc\Filter\Contracts\IsFilter;
use Mtc\Filter\Listeners\RefreshFilterIndexModel;

class FilterEventProvider extends ServiceProvider
{
    /**
     * Get the events and handlers.
     *
     * @return array
     */
    public function listens(): array
    {
        if (config('filter.load_event_provider') != true) {
            return [];
        }

        // Register all models from filters that need to be indexed
        return collect(Config::get('filter.filters'))
            ->map(fn(string $filter_class) => App::make($filter_class))
            ->filter(fn(IsFilter $filter) => $filter->reindexModel() && !empty($filter->getModel()))
            ->map(fn(IsFilter $filter) => "eloquent.saved: " . $filter->getModel())
            ->flip()
            ->map(fn(string $type) => [ RefreshFilterIndexModel::class ])
            ->toArray();
    }
}
