<?php

namespace Mtc\Filter\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;

class MakeFilter extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:filter {name} {--custom-pattern} {--custom-field=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a new filter';

    /**
     * Path where the newly created file be stored
     *
     * @var string
     */
    protected string $destination_directory = 'app/Filter/Filters/';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle(): int
    {
        $class_name = Str::studly($this->argument('name'));
        $content = File::get($this->template());
        $replacements = [
            '{{ClassName}}' => $class_name,
            '{{Implementation}}' => $this->option('custom-pattern') ? ' implements CustomPatternFilter' : '',
            '{{AdditionalMethods}}' => $this->getAdditionalMethodValue(),
            '{{CustomField}}' => $this->option('custom-field') ?? '',
        ];

        $content = str_replace(array_keys($replacements), $replacements, $content);

        File::ensureDirectoryExists(base_path($this->destination_directory));
        File::put(base_path($this->destination_directory . $class_name . '.php'), $content);

        $this->info('Filter option generated. Please add it to your filter config'
            . ' (config/filter.php => filters section).');
        return 0;
    }

    /**
     * Find which template to choose
     *
     * @return string
     */
    private function template(): string
    {
        return $this->option('custom-field')
            ? __DIR__ . '/stubs/custom-field-filter.php.stub'
            : __DIR__ . '/stubs/filter.php.stub';
    }

    /**
     * Get the value for additional methods field
     * @return string
     */
    private function getAdditionalMethodValue(): string
    {
        if ($this->option('custom-pattern')) {
            return File::get(__DIR__ . '/stubs/custom-pattern-filter.php.stub');
        }
        return '';
    }
}
