<?php

namespace Mtc\Filter;

use Illuminate\Support\Facades\File;
use Mtc\Filter\Providers\FilterProvider;
use Mtc\Filter\Seeds\FilterAdminMenuSeed;
use Mtc\Foundation\Contracts\InstallableComponent;

class FilterInstaller implements InstallableComponent
{
    /**
     * Define what needs to be published.
     * This should be formatted in following format:
     *
     * @return array
     */
    public function publish(): array
    {
        return [
            [
                '--provider' => FilterProvider::class,
            ]
        ];
    }

    /**
     * List of npm packages and their version restrictions
     *
     * @return array
     */
    public function npmDependencies(): array
    {
        $package_json = json_decode(File::get(dirname(__DIR__) . '/package.json'), true);
        return $package_json['dependencies'] ?? [];
    }

    /**
     * Whether npm should be run to compile assets after installation has been done
     *
     * @return bool
     */
    public function shouldRunNpm(): bool
    {
        return true;
    }

    /**
     * Provide a classname of seeder that should be called
     * In case of no seed required provide an empty string
     *
     * @return string
     */
    public function seed(): string
    {
        return FilterAdminMenuSeed::class;
    }
}
