<?php

namespace Mtc\Filter\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Mtc\Core\Http\Controllers\Controller;
use Mtc\Filter\Facades\Filter;
use Mtc\Shop\Item;

class FilterController extends Controller
{
    /**
     * Render browse page
     *
     * @param Request $request
     * @return string
     */
    public function index(Request $request): string
    {
        $data = Filter::parseRequest();
        if ($request->has('inaccessible_item')) {
            $data['inaccessible_item'] = Item::query()
                ->select(['name', 'deleted'])
                ->find($request->has('inaccessible_item'));
        }
        return template('filter/index.twig', $data);
    }

    /**
     * Handle Filter ajax call
     *
     */
    public function show(): array
    {
        return Filter::handle();
    }
}
