<?php

namespace Mtc\Filter\Tests\Unit;

use Mtc\Filter\Filters\BrandFilter;
use Mtc\Filter\Filters\CategoryFilter;
use Mtc\Filter\Filters\ColourFilter;
use Mtc\Filter\Filters\PriceFilter;
use Mtc\Filter\Filters\SearchTermFilter;
use Mtc\Filter\Filters\SizeFilter;
use Mtc\Filter\Tests\TestCase;
use Mtc\Shop\Brand;
use Mtc\Shop\Category;
use Mtc\Shop\Item;
use Mtc\Shop\Item\Size;

class IndividualFilterIntegrityTest extends TestCase
{
    public function testCategoryFilter()
    {
        $filter = new CategoryFilter();

        $this->assertEquals('Category', $filter->title());
        $this->assertEquals(Category::class, $filter->getModel());
    }

    public function testBrandFilter()
    {
        $filter = new BrandFilter();

        $this->assertEquals('Brand', $filter->title());
        $this->assertEquals(Brand::class, $filter->getModel());
    }

    public function testSizeFilter()
    {
        $filter = new SizeFilter();

        $this->assertEquals('Size', $filter->title());
        $this->assertEquals(Size::class, $filter->getModel());
    }

    public function testColourFilter()
    {
        $filter = new ColourFilter();

        $this->assertEquals('Colour', $filter->title());
        $this->assertEquals(Size::class, $filter->getModel());
    }

    public function testPriceFilter()
    {
        $filter = new PriceFilter();

        $this->assertEquals('Price', $filter->title());
        $this->assertEquals(Item::class, $filter->getModel());
    }

    public function testSearchFilter()
    {
        $filter = new SearchTermFilter();

        $this->assertEquals('Search', $filter->title());
        $this->assertEquals('', $filter->getModel());
    }

}