<?php

namespace Mtc\Foundation\Rules;

use Illuminate\Contracts\Validation\Rule;
use Mtc\Foundation\Country;
use Mtc\Foundation\PostcodeValidationFactory;

/**
 * Class ValidPostcode
 *
 * @package Mtc\Foundation\Rules
 */
class ValidPostcode implements Rule
{
    /**
     * @var string
     */
    protected $country_code;

    /**
     * Create a new rule instance.
     *
     * @param string $country_code
     * @return void
     */
    public function __construct($country_code)
    {
        $this->country_code = $country_code;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return (new PostcodeValidationFactory($this->country_code))
            ->validates($value);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        $country = Country::query()->where('code', $this->country_code)->firstOrFail();
        return "The postcode must be a valid {$country->name} postcode.";
    }
}
