<?php

namespace Mtc\Foundation;

use Illuminate\Support\Facades\App;
use Mtc\Foundation\Validators\GenericPostcode;
use Mtc\Foundation\Validators\UkPostcode;

/**
 * Class PostcodeValidator
 *
 * Postcode Validator factory class
 * If any additional
 * @package Mtc\Foundation
 */
class PostcodeValidationFactory
{
    /**
     * PostcodeValidator constructor.
     *
     * @param $country_code
     */
    public function __construct($country_code)
    {
        $this->country_code = $country_code;
    }

    /**
     * Validate the postcode
     *
     * @param $postcode
     * @return bool
     */
    public function validates($postcode): bool
    {
        switch (strtoupper($this->country_code)) {
            case 'GB':
                return App::make(UkPostcode::class)->isValid($postcode);
                break;
            default:
                return (new GenericPostcode($this->country_code))->isValid($postcode);
                break;
        }

    }
}
