<?php

namespace Mtc\Foundation\Validators;

use Mtc\Foundation\Country;

/**
 * Class GenericPostcode
 * Postcode class that is not specific to any country.
 * Uses regex stored in database for verification.
 *
 * @package Mtc\Foundation
 */
class GenericPostcode
{

    /**
     * Postcode Validator constructor
     *
     * @param $country_code
     */
    public function __construct($country_code)
    {
        $this->country = Country::query()
            ->where('code', $country_code)
            ->first();
    }

    /**
     * Check if postcode is valid
     *
     * @param $postcode
     * @return bool|false|int
     */
    public function isValid($postcode)
    {
        if (!$this->country) {
            return false;
        }

        if ($this->country->has_postcodes == false || empty($this->country->regex)) {
            return true;
        }
        
        return preg_match(
            "/" . $this->country->regex . "/",
            strtoupper($postcode)
        );
    }
}
