<?php

namespace Mtc\Foundation;

/**
 * Country
 *
 * Select countries from their table
 *
 * @package Mtc\Foundation
 */

class Country extends \Mtc\Core\Models\Country
{
    /**
     * Extend model booting
     */
    protected static function boot()
    {
        parent::boot();

        // Make sure the primary country (e.g. GB) is always first in the country list
        self::addGlobalScope('default_order', function ($query) {
            $country_code = config('foundation.primary_country');
            return $query->orderByRaw("code = '$country_code' desc")
                ->orderBy('name', 'asc');
        });
    }

    /**
     * Relationship with states
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function states()
    {
        return $this->hasMany(State::class, 'country_id');
    }

    /**
     *
     * @return int
     */
    public function getHasStatesAttribute()
    {
        return $this->states->count();
    }
}
