<?php

namespace Mtc\Foundation\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\Core\Models\Country;

/**
 * Class CountryList
 *
 * @package Mtc\Foundation\Http\Resources
 */
class CountryList extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        $this->resource
            ->each(function (Country $country) {
                $visible = [
                    'code',
                    'name',
                ];

                if (config('foundation.country_list_value_fields.states')) {
                    $visible[] = 'has_states';
                    $visible[] = 'states';
                }

                if (config('foundation.country_list_value_fields.counties')) {
                    $visible[] = 'has_counties';
                    $visible[] = 'counties';
                }

                $country->setVisible($visible);
            });
        return parent::toArray($request);
    }
}
