<?php

namespace Mtc\Foundation\Providers;

use Illuminate\Support\Facades\App;
use Illuminate\Support\ServiceProvider;
use Mtc\Core\FormField;
use Mtc\Foundation\Console\Commands\InstallFoundation;
use Twig\TwigFunction;

/**
 * Class FoundationServiceProvider
 *
 * @package Mtc\Foundation\Providers
 */
class FoundationServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        $this->loadViewsFrom(dirname(__DIR__, 2) . '/resources/views', 'foundation');

        if ($this->app->has('twig') !== true) {
            return;
        }

        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'foundation');

        if ($this->app->runningInConsole()) {
            $this->publishes([
                dirname(__DIR__, 2) . '/config/foundation.php' => config_path('foundation.php'),
            ], 'config');

            // Publishing assets.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/js' => resource_path('js/vendor'),
            ], 'assets');

            // Publishing the translation files.
            $this->publishes([
                dirname(__DIR__, 2) . '/resources/lang' => resource_path('lang/vendor/basket'),
            ], 'lang');
        }

        $this->bootTwig();
    }

    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/foundation.php', 'foundation');
    }

    /**
     * Boot Twig functionality
     */
    protected function bootTwig()
    {
        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');
        app('twig')->addFunction(new TwigFunction('admin_filter', function ($field_class) {
            try {
                $options = App::make($field_class)->field();
                $options['layout'] = FormField::LAYOUT_ADMIN_FILTER;
                $options['wrapper_class'] = 'col-lg-4 col-md-6';
                return FormField::renderField($options, app('twig'));
            } catch (\Exception $exception) {
                return '';
            }
        }));
    }
}
