<?php

namespace Mtc\Foundation\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Node
 * Class for storing nodes that can have custom urls
 */
class Node extends Model
{
    use SoftDeletes;

    /**
     * @var array $fillable
     */
    protected $fillable = [
        'url',
        'title',
        'description',
        'status',
        'visibility',
        'node_instance_id',
        'node_instance_type',
    ];

    /**
     * @var string[] columns to hide from output in json
     */
    protected $hidden = [
        'created_at',
        'updated_at'
    ];

    /**
     * Get a list of all owning node instance models.
     *
     * @return MorphTo
     */
    public function nodeInstance()
    {
        return $this->morphTo();
    }

    /**
     * Check if URL already exists
     *
     * @param $url
     * @return bool
     */
    public static function urlExists($url)
    {
        return self::query()
            ->where('url', $url)
            ->exists();
    }

}
