<?php

namespace Mtc\Foundation\Traits;

use Mtc\Foundation\Models\Node;

/**
 * Trait to allow for the connection between a Model and corresponding Node.
 */
trait NodeInstance
{
    /**
     * Define the relationship to the node.
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphOne
     */
    public function node()
    {
        return $this->morphOne(Node::class, 'node_instance');
    }

    /**
     * Get the node_id attribute
     *
     * @return |null
     */
    public function getNodeIdAttribute()
    {
        return $this->node->id ?? null;
    }

    /**
     * Boot trait by adding node creation on model creation
     */
    public static function bootNodeable()
    {
        static::created(function ($node_instance) {
            if ($node_instance->node()->exists() === false) {
                $node_instance->node()
                    ->create([
                        //
                    ]);
            }
        });
    }
}
