<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Payment Gateway keys
    |--------------------------------------------------------------------------
    |
    | Please set site specific keys in .env file
    | Production keys should never be part of tracked repo
    |
    */
    'freedom_pay_store_id' => env('FREEDOM_PAY_STORE_ID', ''),
    'freedom_pay_store_terminal_id' => env('FREEDOM_PAY_STORE_TERMINAL_ID', ''),

    /*
    |--------------------------------------------------------------------------
    | Gateway mode
    |--------------------------------------------------------------------------
    |
    | Whether to use staging or live endpoint
    |
    */
    'use_production_endpoint' => env('FREEDOM_PAY_LIVE', false),

    /*
    |--------------------------------------------------------------------------
    | Payment gateway verifier
    |--------------------------------------------------------------------------
    |
    | Class that allows you to set whether this order can be paid with this payment gateway
    |
    */
    'payment_class' => \Mtc\FreedomPay\FreedomPay::class,
    'applicable_check_class' => \Mtc\FreedomPay\FreedomPayApplicableCheck::class,

    /*
    |--------------------------------------------------------------------------
    | Successful payment
    |--------------------------------------------------------------------------
    |
    | Payment will be considered as successful if it has one of these statuses
    |
    */
    'successful_payment_statuses' => [
        'A',
        'ACCEPTED'
    ],

];
