<?php

namespace Mtc\FreedomPay\Providers;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Route;

/**
 * Class FreedomPayServiceProvider
 *
 * @package Mtc\FreedomPay
 */
class FreedomPayProvider extends RouteServiceProvider
{
    /**
     * Register the application services.
     */
    public function register()
    {
        // Automatically apply the package configuration
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/freedompay.php', 'freedompay');
    }

    /**
     * Bootstrap the application services.
     */
    public function boot()
    {
        $this->loadTranslationsFrom(dirname(__DIR__, 2) . '/resources/lang', 'freedompay');

        app('twig_loader')->addPath(dirname(__DIR__, 2) . '/resources/templates');

        $this->app['payment']->extend('freedompay', function ($app) {
            return App::make(config('freedompay.payment_class'));
        });
        parent::boot();
    }

    public function map()
    {

        Route::middleware('web')->group(dirname(__DIR__, 2) . '/routes/web.php');
    }
}

