<?php

namespace Mtc\GpAddresses\Providers;

use Illuminate\Support\ServiceProvider;
use Mtc\GpAddresses\Console\Commands\FetchNhsOrganisations;

class GpAddressesServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        // Merge config so users can override defaults
        $this->mergeConfigFrom(
            __DIR__ . '/../config/gpaddresses.php',
            'gpaddresses'
        );
    }

    /**
     * Bootstrap package services.
     */
    public function boot(): void
    {
        $this->loadRoutesFrom(__DIR__ . '/../../routes/api.php');

        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../../config/gpaddresses.php' => config_path('gpaddresses.php'),
                __DIR__.'/../../database/migrations' => database_path('migrations'),
            ]);
        }

        $this->commands([
            FetchNhsOrganisations::class,
        ]);
    }
}
