<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('nhs_organisations', function (Blueprint $table) {
            $table->id();
            $table->string('org_id');
            $table->string('name');
            $table->string('status')->default('Active');
            $table->string('org_link');
            $table->timestamps();
            $table->index([
                'org_id',
                'name'
            ]);
            $table->fullText([
                'name'
            ]);
        });
    }

    public function down(): void {
        Schema::dropIfExists('nhs_organisations');
    }
};
