<?php

namespace Mtc\GpAddresses\Providers;

use Illuminate\Support\Facades\Log;
use Illuminate\Support\ServiceProvider;
use Mtc\GpAddresses\Console\Commands\FetchGpAddresses;
use Mtc\GpAddresses\Console\Commands\FetchNhsOrganisations;

class GpAddressesServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap package services.
     */
    public function boot(): void
    {
        Log::info(__METHOD__ . ' Hello there');
        $this->loadRoutesFrom(__DIR__ . '/../../routes/api.php');

        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../../config/gpaddresses.php' => config_path('gpaddresses.php'),
                __DIR__.'/../../database/migrations' => database_path('migrations'),
            ]);

            $this->commands([
                FetchNhsOrganisations::class,
                FetchGpAddresses::class
            ]);
        }

    }
}
