<?php

namespace Mtc\GpAddresses\Console\Commands;

use Mtc\GpAddresses\Services\GpAddressesService;
use Illuminate\Console\Command;

class PullAddressesCommand extends Command
{
    protected $signature = 'gp:pull';

    protected $description = 'Pull Organisations from NHS ODS API and dispatch jobs to fetch their addresses.';

    public function handle(): void
    {
        $service = app(GpAddressesService::class);
        $pullAddresses = true;

        $this->info('Pulling Organisations from NHS ODS API');
        $service->fetchAndStore($pullAddresses);
        $this->info('Finished pulling Organisations... Dispatched jobs to fetch addresses');
    }
}
