<?php

namespace Mtc\GpAddresses\Console\Commands;

use Mtc\GpAddresses\Services\GpAddressesService;

use Illuminate\Console\Command;

class SyncAddressesCommand extends Command
{
    // TODO: Add parameter for a date.
    protected $signature = 'gp:sync';
    protected $description = 'Sync our records for GP Addresses with the NHS ODS API.';

    public function handle(): void
    {
        $service = app(GpAddressesService::class);

        $this->info('Syncing our records with the NHS ODS API.');
        $service->sync();
        $this->info('Finished syncing our records with the NHS records.');
    }
}
