<?php

namespace Mtc\GpAddresses\Providers;

use Illuminate\Support\Facades\Schedule;
use Illuminate\Support\ServiceProvider;
use Mtc\GpAddresses\Services\GpAddressesService;
use Mtc\GpAddresses\Console\Commands\DeleteAddressesCommand;
use Mtc\GpAddresses\Console\Commands\PullAddressesCommand;
use Mtc\GpAddresses\Console\Commands\SyncAddressesCommand;

class GpAddressesServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->singleton(GpAddressesService::class, function ($app) {
            return new GpAddressesService();
        });
    }

    /**
     * Bootstrap package services.
     */
    public function boot(): void
    {
        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/../../config/gpaddresses.php' => config_path('gpaddresses.php'),
                __DIR__ . '/../../database/migrations' => database_path('migrations'),
            ]);

            $this->commands([
                PullAddressesCommand::class,
                SyncAddressesCommand::class,
                DeleteAddressesCommand::class
            ]);

            $this->app->booted(function () {
                $schedule = $this->app->make(Schedule::class);

                $schedule->command(PullAddressesCommand::class)->monthly();

                $schedule->command(SyncAddressesCommand::class)->weekly();

                $schedule->command(DeleteAddressesCommand::class)->daily();
            });
        }
    }
}
