# `mtcmedia/gp-addresses`

The GP Addresses package contains processes for pulling Gp Addresses and contact information from the [NHS ODS](https://www.odsdatasearchandexport.nhs.uk/referenceDataCatalogue/index.html).

# Adding the package

This package is to be included on pharmacy sites with the following command:

```bash
composer require "mtcmedia/gp-addresses"
```

The package should be registered by Laravel's package discovery. In the event that routes such as `https://{APP_URL}/admin/gp-addresses` is not reached you may need to manually add the `GpAddressServiceProvider` to `config/app.php`.

Once you have added the package to the pharmacy site, you will need to run the following commands:

```bash
# To load the new migrations
php artisan migrate

# To check that the package was the routes were loaded correctly
php artisan route:list | grep "gp-addresses"
```

# Setting up Jobs

If the pharmacy site you are working on does not contain a Job queue by default then you may have to setup stuff for jobs. More documentation about Laravel Job Queues can be found [here](https://laravel.com/docs/11.x/queues).

## Database queue driver

To setup the database queue driver, we require a few steps to be done.

```bash
# Build the jobs table
php artisan make:queue-table

# Build the failed jobs table
php artisan make:queue-failed-table
```

# Using the Queue

The following can be done to use the Queues.

## Scheduling the queue to run

Include this at the top of `schedule()` in `app/Console/Kernel.php` to start the job queue.

```php
if (config('queue.default') === 'database') {
    $schedule->command('queue:work --timeout=3600 --stop-when-empty')
        ->everyMinute()
        ->withoutOverlapping();
}
```

## Manually running the queue

If you need to run the queue manually, the following will do the trick.

```
php artisan queue:work --stop-when-empty
```

# Pulling Data

To pull the data, there is a schedule that can run OR you can do the following sections manually.

## Pulling Data

This command takes a long time to process and should only be used for an initial build of all the data or if we need a complete collection of the entire API.

```bash
php artisan gp:pull
```

<!-- TODO In future, update this to include information about Northern Ireland -->
This will collect all the organization's with a `NonPrimaryId` of `RO76` which represents all general practitioner's in the UK excluding Northern Ireland.

Once it has finished collecting all the organizations, jobs will be dispatched to process data in the background. These are the `FetchAddresses` and the `FetchContacts` jobs which go through each organization one by one and pull through the relevant information.

This takes quite a long time to run so leaving it to the job queue is the optimal solution here.

## Syncing Data

```bash
php artisan gp:sync
```

Calls the Sync API from the NHS ODS which returns a list of updated GPs from the last date the command was ran. It does not process a lot of records so it can be ran without much impact to the server.

## Deleting Data

```bash
php artisan gp:delete
```

Deletes any GPs that have been flagged with an error. More details on the errors [here](https://digital.nhs.uk/services/organisation-data-service/organisation-data-service-apis/technical-guidance-ord/sync-endpoint). 

# Vue Component

There is a Vue component that can be used as a reference of added to build system. Pharmacy starter uses vite now so I had added the following to the vite.config.js however, depending on what you are using the instructions might be different.

```js
 resolve: {
            alias: {
                '@site': resolve(__dirname, 'sites/default'),
                '@core': resolve(__dirname, 'core'),
                '@components': resolve(__dirname, 'sites/default/js/components'),
                '@plugins': resolve(__dirname, 'plugins'),
                '@shop': resolve(__dirname, 'shop'),
                '@site_scripts': resolve(__dirname, 'sites/default/js/site_scripts'),
                '@mtcmedia': resolve(__dirname, 'vendor/mtcmedia/'), // Resolve the path to mtcmedia dependencies
                // Add this line to use the full Vue build
                'vue': 'vue/dist/vue.esm.js'
            },
            extensions: ['.mjs', '.js', '.ts', '.jsx', '.tsx', '.json', '.vue'],
        },
```

```js
// main-app.js

import "@mtcmedia/gp-addresses/resources/js/mtc_gp_addresses.js"; // Import it.
```

The process for importing the package should be the same throughout all the sites in which case just import the full path.
