<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('gp_contact_information', function (Blueprint $table) {
            $table->id();
            $table->foreignId('nhs_organisation_id')
                ->constrained()
                ->cascadeOnDelete();
            $table->string('telephone_number', 20)->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('contacts');
    }
};
