<?php

namespace Mtc\GpAddresses\Console\Commands;

use Illuminate\Console\Command;
use Mtc\GpAddresses\Services\GpAddressesService;

class DeleteAddressesCommand extends Command
{
    protected $signature = 'gp:delete';
    protected $description = 'Check for notifications of deleted records from the NHS and delete them from our records..';

    public function handle(): void
    {
        $service = app(GpAddressesService::class);

        $this->info('Check');
        $service->delete();
        $this->info('Finished pulling Organisations... Dispatched jobs to fetch addresses');
    }
}
