<?php

namespace Mtc\GpAddresses\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Mtc\GpAddresses\Models\NhsOrganisation;
use Mtc\GpAddresses\Models\GpContactInformation;

class FetchContacts implements ShouldQueue
{
    use Queueable;

    public function __construct(public $links) {}

    public function handle()
    {
        $contacts = [];

        foreach ($this->links as $link) {

            $attempts = 0;

            do {
                $response = Http::retry(3, 10000)
                    ->get($link);

                $attempts++;

                Log::info("Fetching $link, attempt #$attempts, status {$response->status()}.");

                if ($response->ok()) {

                    $orgId = $response->json('Organisation.OrgId.extension') ?? null;
                    $org = NhsOrganisation::where('org_id', $orgId)->value('id');

                    if ( !$org ) {
                        Log::warning("No records for $orgId exist.");
                        continue;
                    }

                    // Collect the values and flatten them.
                    $contact = $response->json('Organisation.Contacts.Contact') ?? null;

                    $contact = collect($contact)->flatten(1);

                    $contacts[] = [
                        'nhs_organisation_id' => $org,
                        'telephone_number'    => $contact[1], // Only gets telephone number
                    ];

                    break;
                }

            } while ($response->status() === 429 && $attempts < 5);
        }


        if (!empty($contacts)) {

            $count = count($contacts);
            Log::info("Found $count contacts.");
            GpContactInformation::upsert(
                $contacts,
                ['nhs_organisation_id', 'telephone_number'],
                ['nhs_organisation_id', 'telephone_number'],
            );
        }
    }
}
