<?php

namespace Mtc\GpAddresses\Models;

use Mtc\GpAddresses\Models\NhsOrganisation;
use Illuminate\Database\Eloquent\Model;

class GpAddress extends Model {
    protected $fillable = [
        'nhs_organisation_id',
        'uprn',
        'address_line_1',
        'address_line_2',
        'town',
        'county',
        'postcode',
        'country',
    ];

    public function organisation()
    {
        return $this->belongsTo(NhsOrganisation::class, 'nhs_organisation_id');
    }

}
