<?php

namespace Mtc\GpAddresses\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\GpAddresses\Models\NhsOrganisation;

class GpContactInformation extends Model
{
    protected $fillable = [
        'nhs_organisation_id',
        'telephone_number',
    ];

    public function organisation(): BelongsTo
    {
        return $this->belongsTo(NhsOrganisation::class, 'nhs_organisation_id');
    }
}
