<?php

namespace Mtc\GpAddresses\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class NhsOrganisationResource extends JsonResource
{
    public function toArray($request)
    {
        $address = $this->whenLoaded('address');
        $contact = $this->whenLoaded('contact');

        $addressLine = [];

        if ($address?->address_line_1) {
            $addressLine[] = $address->address_line_1;
        }

        if ($address?->address_line_2) {
            $addressLine[] = $address->address_line_2;
        }

        if ($address?->town) {
            $addressLine[] = $address->town;
        }

        if ($address?->county) {
            $addressLine[] = $address->county;
        }

        if ($address?->postcode) {
            $addressLine[] = $address->postcode;
        }

        if ($address?->country) {
            $addressLine[] = $address->country;
        }

        return [
            'id' => $this->id,
            'name' => $this->name,
            'ods_code' => $this->ods_code,
            'address' => $addressLine ? implode(', ', $addressLine) : null,
            'telephone_number' => $contact?->telephone_number,
            'status' => $this->status,
            'last_updated' => $this->updated_at->diffForHumans()
        ];
    }
}
