<?php

namespace Mtc\GpAddresses\Models;

use Illuminate\Database\Eloquent\Model;
use Mtc\GpAddresses\Models\GpAddress;
use Mtc\GpAddresses\Models\GpContactInformation;

class NhsOrganisation extends Model
{
    protected $fillable = [
        'org_id',
        'name',
        'status',
        'org_link',
    ];

    public function address()
    {
        return $this->hasOne(GpAddress::class, 'nhs_organisation_id');
    }

    public function contact()
    {
        return $this->hasOne(GpContactInformation::class, 'nhs_organisation_id');
    }
}
