<?php

namespace Mtc\GpAddresses\Providers;

use Illuminate\Support\ServiceProvider;
use Mtc\GpAddresses\Services\GpAddressesService;
use Mtc\GpAddresses\Console\Commands\DeleteAddressesCommand;
use Mtc\GpAddresses\Console\Commands\PullAddressesCommand;
use Mtc\GpAddresses\Console\Commands\SyncAddressesCommand;
use Illuminate\Console\Scheduling\Schedule;

class GpAddressesServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/gpaddresses.php',
            'gpaddresses'
        );

        $this->app->singleton(GpAddressesService::class, function ($app) {
            return new GpAddressesService();
        });
    }

    /**
     * Bootstrap package services.
     */
    public function boot(): void
    {
        $this->loadRoutesFrom(__DIR__ . '/../../routes/web.php');

        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations/');

        $this->registerTwigTemplatePath();


        if ($this->app->runningInConsole()) {

            $this->commands([
                PullAddressesCommand::class,
                SyncAddressesCommand::class,
                DeleteAddressesCommand::class
            ]);

            $this->app->booted(function () {
                $schedule = $this->app->make(Schedule::class);
                $schedule->command(PullAddressesCommand::class)->monthly();
                $schedule->command(SyncAddressesCommand::class)->weekly();
                $schedule->command(DeleteAddressesCommand::class)->daily();
            });
        }
    }

    protected function registerTwigTemplatePath(): void
    {
        // Pharmacy platform uses custom twig template loaders.
        $view_paths = \Config::get('view.paths');
        $view_paths[] = dirname(__DIR__, 2) . '/resources/templates';
        \Config::set('view.paths', $view_paths);
    }
}
