# `mtcmedia/gp-addresses`

*Any issues/questions regarding this package, feel free to reach out to `jack.jefferson@mtc.co.uk`*

The GP Addresses package contains processes for pulling Gp Addresses and contact information from the [NHS ODS](https://www.odsdatasearchandexport.nhs.uk/referenceDataCatalogue/index.html).

# Including the package

To include the package onto a pharmacy site, do the following command:

```
composer require "mtcmedia/gp-addresses"
```

# Setting up the jobs

If the pharmacy site you are working on does not contain a Job queue by default then you may have to setup stuff for jobs. More documentation about Laravel Job Queues can be found [here](https://laravel.com/docs/11.x/queues).

## Database queue driver

To setup the database queue driver, we require a few steps to be done.

```bash
# Build the jobs table
php artisan make:queue-table

# Build the failed jobs table
php artisan make:queue-failed-table
```

The following can be done to use the Queues.

## Scheduling the queue to run

Include this at the top of `schedule()` in `app/Console/Kernel.php` to start the job queue.

```php
if (config('queue.default') === 'database') {
    $schedule->command('queue:work --timeout=3600 --stop-when-empty')
        ->everyMinute()
        ->withoutOverlapping();
}
```

## Manually running the queue

If you need to run the queue manually, the following will do the trick.

```
php artisan queue:work
```
The package should be registered by Laravel's package discovery, if the package is not auto-discovered you may need to manually add the `GpAddressServiceProvider` to `config/app.php`.

# After including the package

Once the package has been included and the jobs have been setup, run the following commands:

```
# Load new migrations
php artisan migrate

# Check that routes have been loaded correctly
php artisan route:list | grep "gp-addresses"
```

If these run with no issues then the package should have been included with no issues and you can move on to setting up the package for the site.


# Commands

Below are some of the commands that you can run to manually setup jobs to run.

## Pulling Data

This command checks the current data for things like dates or total counts. If it finds any issues, it does a full data pull. Otherwise, it just syncs the changes. Full pulls can take a while, so this is mainly for initial setup or large updates.

```
php artisan gp:pull
```

## Syncing Data

Looks for a last date and then runs the command to fetch data since that date.

```
php artisan gp:sync
```

## Deleting Data

Checks to see if any records have been deleted from the NHS ODS API. 

```
php artisan gp:delete
```

More details [here](https://digital.nhs.uk/services/organisation-data-service/organisation-data-service-apis/technical-guidance-ord/notifications-endpoint).

# Registering Vue Component

**DISCLAIMER: THIS IS INTENDED FOR VITE, THESE STEPS MAY DIFFER BETWEEN BUILD SYSTEMS**

`pharmacy-starter` uses vite as the build system and in order to make importing the vue component and styling easier, a custom import is recommended.

```js
 resolve: {
            alias: {
                '@site': resolve(__dirname, 'sites/default'),
                '@core': resolve(__dirname, 'core'),
                '@components': resolve(__dirname, 'sites/default/js/components'),
                '@plugins': resolve(__dirname, 'plugins'),
                '@shop': resolve(__dirname, 'shop'),
                '@site_scripts': resolve(__dirname, 'sites/default/js/site_scripts'),
                '@mtcmedia': resolve(__dirname, 'vendor/mtcmedia/'), // Resolve the path to mtcmedia dependencies
            },
            extensions: ['.mjs', '.js', '.ts', '.jsx', '.tsx', '.json', '.vue'],
        },
```

Then import it in `main-app.js`.

```js
// main-app.js

import "@mtcmedia/gp-addresses/resources/js/mtc_gp_addresses.js"; // Import it.
```
