<?php

namespace MtcMedia\Helpers;

/**
 * Class Image
 * @package Mtc
 *
 * @method existsLarge()
 * @method existsSmall()
 * @method existsMedium()
 *
 * @method srcLarge()
 * @method srcSmall()
 * @method srcMedium()
 *
 * @method pathLarge()
 * @method pathSmall()
 * @method pathMedium()
 *
 * @method configLarge()
 * @method configSmall()
 * @method configMedium()
 */

class Image
{
    public $configFolders;
    public $owner;
    public $name;

    public function __construct($name, $configFolders = null)
    {
        $this->name  = $name;
        $this->configFolders = $configFolders ?: $GLOBALS['cms_images'];
    }

    public function __call($method, $args)
    {
        if (strpos($method, 'exists') === 0) {
            // empty name means image doesn not exist
            if (!$this->name) { return false; }

            $size = strtolower(str_replace('exists', '', $method));
            return $this->exists($size);

        } elseif (strpos($method, 'src') === 0)  {

            $size = strtolower(str_replace('src', '', $method));
            return $this->src($size);

        } elseif (strpos($method, 'path') === 0)  {

            $size = strtolower(str_replace('path', '', $method));
            return $this->path($size);

        } elseif (strpos($method, 'config') === 0)  {

            $size = strtolower(str_replace('config', '', $method));
            return $this->configFolders[$size][$args[0]];

        } else {
            throw new \BadMethodCallException;
        }
    }

    public function exists($size)
    {
        if (!$this->name) { return false; }
        return file_exists($this->path($size));
    }

    public function path($size)
    {
        return SITE_PATH . $this->src($size);
    }

    public function src($size)
    {
        return '/' . rtrim($this->configFolders[$size]['path'], '/') . '/' . $this->name;
    }

    public static function __set_state($an_array)
    {
        $image = new Image($an_array['name'], $an_array['configFolders']);
        $image->owner = $an_array['owner'];
        return $image;
    }
}
